/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "..\x86emu.h"

// XCHG
int op_xchg(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    dword* src=0;
    if (s->flags & SRC_REG){
          src=&thread.Exx[s->nsrc];
          if (s->flags & SRC_BITS8 && s->nsrc>3){
              char* src2=(char*)&thread.Exx[s->nsrc-4]; 
              src2++;
              src=(dword*)src2;        
          };
    }else if (s->flags & SRC_RM){
          src =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          //this place for checking for write access
          thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)src);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32){ 
                       memcpy(&thread.Exx[s->ndest],src,4);
                       memcpy(src,&dest,4);
                       }
          if (s->flags & DEST_BITS16){ 
                       memcpy(&thread.Exx[s->ndest],src,2);
                       memcpy(src,&dest,2);
                       }
          if (s->flags & DEST_BITS8) { 
                          if (s->ndest>3){
                              char* dest2=(char*)&thread.Exx[s->ndest-4]; 
                              dest2++;
                              char dest3=*dest2;
                              memcpy(dest2,src,1);
                              memcpy(src,&dest3,1);
                           }else{
                               memcpy(&thread.Exx[s->ndest],src,1);
                               memcpy(src,&dest,1);
                           };
          };
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dest=*ptr;
          if (s->flags & DEST_BITS32){
             dword n=*src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             memcpy(src,&dest,4);
          };
          if (s->flags & DEST_BITS16){
             short n=*src;          
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
             memcpy(src,&dest,2);
          };
          if (s->flags & DEST_BITS8){
             char n=*src;   
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
             memcpy(src,&dest,1);
          };
          result=*ptr;
    };  
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";     
};
//==============================================================================================================================
// BSWAP
int op_bswap(Thread& thread,ins_disasm* s){
        dword dest,result;
          
          if (s->flags & DEST_BITS32){
                       int src=thread.Exx[s->ndest];
                       __asm(
                       "bswap %%eax"
                       :"=a"(src)
                       :"a"(src)
                       );
                       memcpy(&thread.Exx[s->ndest],&src,4);
          };
          if (s->flags & DEST_BITS16){
                       short src=thread.Exx[s->ndest];
                       short s2=(src &0xff)<<16;
                       short s3=(src &0xff00)>>16;
                       src=s2+s2;
                       memcpy(&thread.Exx[s->ndest],&src,2);
          };
}
//==============================================================================================================================
// XADD
int op_xadd(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    dword* src=0;
    if (s->flags & SRC_REG){
          src=&thread.Exx[s->nsrc];
    }else if (s->flags & SRC_RM){
          src =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          //this place for checking for write access
          thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)src);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32){ 
                       memcpy(&thread.Exx[s->ndest],src,4);
                       memcpy(src,&dest,4);
                       }
          if (s->flags & DEST_BITS16){ 
                       memcpy(&thread.Exx[s->ndest],src,2);
                       memcpy(src,&dest,2);
                       }
          if (s->flags & DEST_BITS8) { 
                       memcpy(&thread.Exx[s->ndest],src,1);
                       memcpy(src,&dest,1);
                       }
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dest=*ptr+*src;
          if (s->flags & DEST_BITS32){
             dword n=*src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             memcpy(src,&dest,4);
          };
          if (s->flags & DEST_BITS16){
             short n=*src;          
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
             memcpy(src,&dest,2);
          };
          if (s->flags & DEST_BITS8){
             char n=*src;   
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
             memcpy(src,&dest,1);
          };
          result=*ptr;
    };
    thread.updateflags(dest,0,result,UPDATEFLAGS_ADD);
}
//==============================================================================================================================
//MUL

int op_mul(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    int a,b;
    if (s->flags & DEST_REG){
          int src2=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32)memcpy(&src,&src2,4);
          if (s->flags & DEST_BITS16)memcpy(&src,&src2,2);
          if (s->flags & DEST_BITS8){
             if (s->ndest >3)src2=thread.Exx[s->ndest-4] >> 8;          
             memcpy(&src,&src2,1);  
             };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & DEST_BITS32)memcpy(&src,ptr,4);
          if (s->flags & DEST_BITS16)memcpy(&src,ptr,2);
          if (s->flags & DEST_BITS8)memcpy(&src,ptr,1); 
    };
    if (s->flags & DEST_BITS32){
        __asm(
              "mul %%edx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"d"(src)                 //the inputs
              );
    }else if (s->flags & DEST_BITS16){
        __asm(
              "mul %%cx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])          //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])    //the inputs
              );          
    }else if (s->flags & DEST_BITS8){
        __asm(
              "mul %%cl"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])              //the inputs
              );    
    }
}
//==============================================================================================================================
//IMUL
int op_imul1(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    int a,b;
    if (s->flags & DEST_REG){
          int src2=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32)memcpy(&src,&src2,4);
          if (s->flags & DEST_BITS16)memcpy(&src,&src2,2);
          if (s->flags & DEST_BITS8){
             if (s->ndest >3)src2=thread.Exx[s->ndest-4] >> 8;          
             memcpy(&src,&src2,1);
             };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & DEST_BITS32)memcpy(&src,ptr,4);
          if (s->flags & DEST_BITS16)memcpy(&src,ptr,2);
          if (s->flags & DEST_BITS8)memcpy(&src,ptr,1); 
    };
    if (s->flags & DEST_BITS32){
        __asm(
              "imul %%edx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"d"(src)                 //the inputs
              );
    }else if (s->flags & DEST_BITS16){
        __asm(
              "imul %%cx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])          //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])    //the inputs
              );          
    }else if (s->flags & DEST_BITS8){
        __asm(
              "imul %%cl"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])              //the inputs
              );          
    };
};
//-------------------------------------------------------------------------------------------------------------------------
//IMUL 2
int op_imul2(Thread& thread,ins_disasm* s){
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc;
    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[s->nsrc];
          if (s->flags & SRC_BITS32)memcpy(&src,&src2,4);
          if (s->flags & SRC_BITS16)memcpy(&src,&src2,2);
          if (s->flags & SRC_BITS8)memcpy(&src,&src2,1); 
    }else if (s->flags & SRC_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & SRC_BITS32)memcpy(&src,ptr,4);
          if (s->flags & SRC_BITS16)memcpy(&src,ptr,2);
          if (s->flags & SRC_BITS8)memcpy(&src,ptr,1); 
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          src*=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32) memcpy(&thread.Exx[s->ndest],&src,4);
          if (s->flags & DEST_BITS16) memcpy(&thread.Exx[s->ndest],&src,2);
          if (s->flags & DEST_BITS8) memcpy(&thread.Exx[s->ndest],&src,1);
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n*=src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n*=src;          
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n*=src;   
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };  
    thread.updateflags(dest,0,result,UPDATEFLAGS_ADD);
};
//-------------------------------------------------------------------------------------------------------------------------
//IMUL 3
int op_imul3(Thread& thread,ins_disasm* s){
    dword dest,result;
    int src=0,imm=s->other;
    if (s->flags & SRC_IMM){
             src=s->nsrc;
    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[s->nsrc];
          if (s->flags & SRC_BITS32)memcpy(&src,&src2,4);
          if (s->flags & SRC_BITS16)memcpy(&src,&src2,2);
          if (s->flags & SRC_BITS8)memcpy(&src,&src2,1); 
    }else if (s->flags & SRC_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & SRC_BITS32)memcpy(&src,ptr,4);
          if (s->flags & SRC_BITS16)memcpy(&src,ptr,2);
          if (s->flags & SRC_BITS8)memcpy(&src,ptr,1); 
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          src*=imm;
          if (s->flags & DEST_BITS32) memcpy(&thread.Exx[s->ndest],&src,4);
          if (s->flags & DEST_BITS16) memcpy(&thread.Exx[s->ndest],&src,2);
          if (s->flags & DEST_BITS8) memcpy(&thread.Exx[s->ndest],&src,1);
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n=imm*src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n=imm*src;          
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n=imm*src;   
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };  
    thread.updateflags(dest,0,result,UPDATEFLAGS_ADD);
};
//==============================================================================================================================
//DIV

int op_div(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    int a,b;
    if (s->flags & DEST_REG){
          int src2=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32)memcpy(&src,&src2,4);
          if (s->flags & DEST_BITS16)memcpy(&src,&src2,2);
          if (s->flags & DEST_BITS8){
             if (s->ndest >3)src2=thread.Exx[s->ndest-4] >> 8;        
             memcpy(&src,&src2,1);
             };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & DEST_BITS32)memcpy(&src,ptr,4);
          if (s->flags & DEST_BITS16)memcpy(&src,ptr,2);
          if (s->flags & DEST_BITS8)memcpy(&src,ptr,1); 
    };
    if (src==0)throw(EXP_DIVID_BY_ZERO);
    if (s->flags & DEST_BITS32){
       if (thread.Exx[2] >= src)throw(EXP_DIV_OVERFLOW);
        __asm(
              "div %%ecx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])               //the inputs
              );
    }else if (s->flags & DEST_BITS16){
          if ((thread.Exx[2] & 0xFFFF) >= (src & 0xFFFF))throw(EXP_DIV_OVERFLOW);
        __asm(
              "div %%cx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])          //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])    //the inputs
              );          
    }else if (s->flags & DEST_BITS8){
          if ((thread.Exx[2] & 0xFF) >= (src & 0xFF))throw(EXP_DIV_OVERFLOW);
        __asm(
              "div %%cl"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])          //the inputs
              );          
    };
}
//==============================================================================================================================
//IDIV

int op_idiv(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    int a,b;
    if (s->flags & DEST_REG){
          int src2=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32)memcpy(&src,&src2,4);
          if (s->flags & DEST_BITS16)memcpy(&src,&src2,2);
          if (s->flags & DEST_BITS8){
             if (s->ndest >3)src2=thread.Exx[s->ndest-4] >> 8;          
             memcpy(&src,&src2,1);
             };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          if (s->flags & DEST_BITS32)memcpy(&src,ptr,4);
          if (s->flags & DEST_BITS16)memcpy(&src,ptr,2);
          if (s->flags & DEST_BITS8)memcpy(&src,ptr,1); 
    };
    if (src==0)throw(EXP_DIVID_BY_ZERO);
    if (s->flags & DEST_BITS32){
       if ((thread.Exx[2]<< 1) >= src)throw(EXP_DIV_OVERFLOW);
       
        __asm(
              "idiv %%ecx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])               //the inputs
              );
    }else if (s->flags & DEST_BITS16){
          if (((thread.Exx[2] & 0xFFFF)<< 1) >= (src & 0xFFFF))throw(EXP_DIV_OVERFLOW);
        __asm(
              "idiv %%cx"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])          //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])    //the inputs
              );          
    }else if (s->flags & DEST_BITS8){
          if (((thread.Exx[2] & 0xFF)<< 1) >= (src & 0xFF))throw(EXP_DIV_OVERFLOW);
        __asm(
              "idiv %%cl"
              :"=a"(thread.Exx[0]),"=d"(thread.Exx[2])    //saves in eax,edx  
              :"a"(thread.Exx[0]),"c"(src),"d"(thread.Exx[2])              //the inputs
              );          
    }
}
